/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.items;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.npcs.CustomRegisters;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.item.ISpecBuilder;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.items.ItemBuilder;
import noppes.npcs.util.BuilderData;
import noppes.npcs.util.IPermission;

public class ItemPlacer
extends Item
implements IPermission,
ISpecBuilder {
    private final EnumGuiType guiType = EnumGuiType.PlacerSetting;

    public ItemPlacer() {
        this.setRegistryName("customnpcs", "npcplacer");
        this.func_77655_b("npcplacer");
        this.field_77777_bU = 1;
        this.func_77637_a(CustomRegisters.tab);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> list, @Nonnull ITooltipFlag flagIn) {
        BuilderData builder = ItemBuilder.getBuilder(stack, null);
        list.add(new TextComponentTranslation("info.item.builder.main.0", new Object[0]).func_150254_d());
        list.add(new TextComponentTranslation("info.item.builder.main.1", new Object[0]).func_150254_d());
        if (builder != null) {
            list.add(new TextComponentTranslation("info.item.placer", new Object[0]).func_150254_d());
            for (int i = 4; i <= 5; ++i) {
                list.add(new TextComponentTranslation("info.item.builder.main." + i, new Object[0]).func_150254_d());
            }
            list.add(new TextComponentTranslation("info.item.builder.range.1", new Object[]{"" + builder.region[0], "" + builder.region[1], "" + builder.region[2]}).func_150254_d());
        } else {
            list.add(new TextComponentTranslation("info.item.builder.main.2", new Object[0]).func_150254_d());
            if (stack.func_77942_o() && stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("ID", 8) && stack.func_77978_p().func_150297_b("BuilderType", 3)) {
                NoppesUtilPlayer.sendDataCheckDelay(EnumPlayerPacket.GetBuildData, stack, 2000L, stack.func_77978_p().func_74779_i("ID"), stack.func_77978_p().func_74762_e("BuilderType"));
            }
        }
    }

    @Override
    public boolean isAllowed(EnumPacketServer e) {
        return e == EnumPacketServer.BuilderSetting || e == EnumPacketServer.Gui || e == EnumPacketServer.SchematicsBuild;
    }

    @Override
    public void leftClick(ItemStack stack, EntityPlayerMP player, BlockPos pos) {
        if (pos == null) {
            return;
        }
        PlayerData data = PlayerData.get((EntityPlayer)player);
        BuilderData builder = ItemBuilder.getBuilder(stack, (EntityPlayer)player);
        if (data == null || !stack.func_77942_o() || builder == null || builder.getID() == -1) {
            NoppesUtilServer.sendOpenGui((EntityPlayer)player, this.guiType, null, -1, this.getType(), 0);
            return;
        }
        if (data.hud.hasOrKeysPressed(29, 157)) {
            builder.undo();
        }
    }

    @Override
    public void rightClick(ItemStack stack, EntityPlayerMP player, BlockPos pos) {
        if (pos == null) {
            return;
        }
        PlayerData data = PlayerData.get((EntityPlayer)player);
        BuilderData builder = ItemBuilder.getBuilder(stack, (EntityPlayer)player);
        if (data == null || !stack.func_77942_o() || builder == null || builder.getID() == -1) {
            NoppesUtilServer.sendOpenGui((EntityPlayer)player, this.guiType, null, -1, this.getType(), 0);
            return;
        }
        if (data.hud.hasOrKeysPressed(29, 157)) {
            builder.redo();
            return;
        }
        builder.work(pos, player);
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public EnumGuiType getGUIType() {
        return this.guiType;
    }
}

